unit uAddAkt;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, DB, ADODB, Buttons, System.UITypes;

type
  TfrmAddAkt = class(TForm)
    AktDateTimePicker: TDateTimePicker;
    AktNumberEdit: TEdit;
    AktNumberLabel: TLabel;
    AktDatePickerLabel: TLabel;
    SaveBtn: TButton;
    CancelBtn: TButton;
    UpdateAkt: TADOQuery;
    procedure SaveBtnClick(Sender: TObject);
  private
    { Private declarations }
    idSender: Integer;
    compilingYear: Integer;
    number: Int64;
    Edit: Boolean;
    docNumber: string;
    docDate: TDateTime;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; idSender, compilingYear: Integer;
      number: Int64); reintroduce; overload;
    constructor Create(AOwner: TComponent; idSender, compilingYear: Integer;
      number: Int64; docNumber: string; docDate: TDateTime); reintroduce; overload;
  end;

var
  frmAddAkt: TfrmAddAkt;

implementation

uses
  uDM, UtilUnit;

{$R *.dfm}

constructor TfrmAddAkt.Create(AOwner: TComponent; idSender, compilingYear: Integer; number: Int64);
begin
  inherited Create(AOwner);

  Self.idSender := idSender;
  Self.compilingYear := compilingYear;
  Self.number := number;
  Self.Edit := False;

  AktDateTimePicker.DateTime := Now();
end;

constructor TfrmAddAkt.Create(AOwner: TComponent; idSender, compilingYear:
  Integer; number: Int64; docNumber: string; docDate: TDateTime);
begin
  inherited Create(AOwner);

  Self.idSender := idSender;
  Self.compilingYear := compilingYear;
  Self.number := number;
  Self.Edit := True;
  Self.docNumber := docNumber;
  Self.docDate := docDate;

  AktDateTimePicker.DateTime := docDate;
  AktNumberEdit.Text := docNumber;
end;

procedure TfrmAddAkt.SaveBtnClick(Sender: TObject);
begin
  if (Length(Trim(AktNumberEdit.Text)) = 0) then
  begin
    MessageDlg('       ', mtError, [mbOK], 0);
    Exit;
  end;

  try
    if not Edit then
      DM.InsertDocument(idSender, compilingYear, number, 606, FormatDateTime('dd.mm.yyyy',
        AktDateTimePicker.Date), Null, Null, IntToStrWithZeros(StrToInt(AktNumberEdit.Text),
        7), 7, Null, Null)
    else
      with UpdateAkt do
      begin
        Parameters.ParamByName('idSender').Value := idSender;
        Parameters.ParamByName('compilingYear').Value := compilingYear;
        Parameters.ParamByName('number').Value := number;
        Parameters.ParamByName('docDate').Value := docDate;
        Parameters.ParamByName('docNumber').Value := docNumber;
        Parameters.ParamByName('newDocDate').Value := FormatDateTime('dd.mm.yyyy', AktDateTimePicker.Date);
        Parameters.ParamByName('newDocNumber').Value := IntToStrWithZeros(StrToInt(AktNumberEdit.Text), 7);
        ExecSQL;
      end;
  except
    on EInv: EInvoiceException do
      MessageDlg(EInv.Message, mtError, [mbOK], 0);
    on E: Exception do
      MessageDlg('   : '+e.Message, mtError, [mbOK], 0);
  end;
end;

end.

